implementation module Random


import	StdInt, StdClass
from	StdTime	import	getCurrentTime, Time
from	StdPSt	import	PSt, IOSt


::	RandomSeed	:== Int


nullRandomSeed :: RandomSeed
nullRandomSeed
	=	0

getNewRandomSeed :: !(PSt .l .p) -> (!RandomSeed, !PSt .l .p)
getNewRandomSeed pState
	#	({hours,minutes,seconds}, pState)	= getCurrentTime pState
	=	(1+(hours+minutes+seconds) bitand 65535, pState)

random :: !RandomSeed -> (!Int,!RandomSeed)
random seed
	=	(newSeed,newSeed)
where
	newSeed		= if (nextSeed>=0) nextSeed (nextSeed+65537)
	nextSeed	= (seed75 bitand 65535)-(seed75>>16)
	seed75		= seed*75
